-- ****************************************************
-- * ADDON TEMPLATE, CUSTOMIZE AT WILL *
-- ****************************************************
-- NOTE: Any line with "--" in front of it will not be read by your computer.
-- If you want any part of the code below to be read, remove the dashes, 
-- or add dashes to comment out desired code.


-- ****************************************************
-- * ON_LOAD COMMANDS * 
-- ****************************************************
-- Add any code that needs to be read OnLoad in the section below; for example,
-- add or delete load messages, and add slash commands here.
--
-- The first function below prints a small notification in chat to 
-- let you know that the addon successfully loaded.


function PermaLog_OnLoad()
if( DEFAULT_CHAT_FRAME ) then
  DEFAULT_CHAT_FRAME:AddMessage("PermaLog Loaded");
end
  UIErrorsFrame:AddMessage("PermaLog Loaded", 1.0, 1.0, 1.0, 1.0, UIERRORS_HOLD_TIME);
  LoggingChat(1);
-- Remove the comment from the next line to enable combat logs
--  LoggingCombat(1);
-- PlaySoundFile("Sound\\Creature\\CThun\\CThunYouWillDIe.wav");

  DEFAULT_CHAT_FRAME:AddMessage("PermaLog: Now logging chat");


-- The two lines below add an in-game Slash Command for the LootDogNow1 function.
--   SlashCmdList["LOOT_DOG_NOW1"] = LootDogNow1;
--   SLASH_LOOT_DOG_NOW11 = "/dog1";

-- These two lines make a slash command for the Track Item function.
--  SlashCmdList["TRACK_ITEM"] = TrackItem;
--  SLASH_TRACK_ITEM1 = "/ti";

-- The line below adds a colored load message with instructions for use the Track Item function.
--   DEFAULT_CHAT_FRAME:AddMessage("**To track an item, place it in slot 0,1 and use /ti to announce.**", 1.0, 0.35, 0.15);
-- end;

end



-- ****************************************************
-- * FUNCTIONS * 
-- ****************************************************
-- Add your functions in the section below. I've also included several basic but 
-- useful functions below to get you started. 















-- ****************************************************
-- * TRACK ITEM AND ANNOUNCE * 
-- ****************************************************
-- Put any item in the top left slot of your main backpack; when you call this function it counts
--  the total number of the item you have in your bags and announces it to your party.
--
function TrackItem()
   local itemLink = GetContainerItemLink(0,1); SendChatMessage("I have " .. GetItemCount(GetContainerItemLink(0,1)) .. "x" .. itemLink, "PARTY");
  end



-- ****************************************************
-- * LOOT HAIKU * 
-- ****************************************************
-- This function lets you send a haiku to a chat channel (here "raidchat", adjust as necessary)
-- asking people to loot the dog, and adds a slash command "/dog1"(commented out, above) for 
-- in-game use. Use with care, as too much haiku can be a dangerous thing!
-- 
-- ***These functions are the actual meat of the /LootDogNow1 command
--
-- function LootDogNow1()
--     SendChatMessage("Did you check for loot?", "CHANNEL", lang, GetChannelName("raidchat"));
--     SendChatMessage("Core Hounds carry things in the", "CHANNEL", lang, GetChannelName("raidchat"));
--     SendChatMessage("Strangest of places.", "CHANNEL", lang, GetChannelName("raidchat")); end



-- ****************************************************
-- * RANDOM PHRASE GENERATOR * 
-- ****************************************************
-- This function lets you build a long list of phrases and then pick 
-- one at random when casting a given spell or performing another action. 
-- *Note: replace the "Phrase #s" with your funny/cool sayings, and update 
-- "random(1,6)" to reflect your final number of sayings ("1,50" for ex.).
-- You can also substitute GUILD or RAID for SAY.
-- All thanks to Tonukuropan for this code.
-- 
-- In WoW, use the macro:
-- /cast YourDesiredSpellHere(Rank 1)
-- /script SendChatMessage(RandSay1(), "SAY") 
--
-- ***If you want to say something random a certain percent of the time, use the following
-- in-game macro instead. If you exclude "(Rank #)" it will automatically cast your highest rank of that spell. 
-- This code will say something 1% of the time when casting; 
-- changing the (100) to a (1) gives you 100%, or to (20) for 5% (or 1 time in 20):
-- /cast YourDesiredSpellHere(Rank 1)
-- /script if(math.random(100) == 1) then SendChatMessage(RandSay1(), "SAY") end
--
-- To send the message to a non-standard channel, adapt the following in-game macro:
-- /cast YourDesiredSpellHere(Rank 1)
-- /script if(math.random(100) == 1) then SendChatMessage(RandSay1(), "CHANNEL", lang, GetChannelName("channelnamehere")) end

-- Change the phrases below to whatever you want to say, and update the "6" in "random(1,6)" to equal your 
-- final number of phrases. To activate the addon just remove the dashes below.
--
-- function RandSay1() 
--  local s = { 
--      "Phrase 1", "Phrase 2", 
--      "Phrase 3", "Phrase 4", 
--      "Phrase 5", "Phrase 6" 
--    }; 
--    local i = random(1,6); 
--    return s[i]; 
--  end; 



